'use strict';

/* --------------------------------------------------------------
 modal.js 2016-02-23
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

jse.libs.theme.modal = jse.libs.theme.modal || {};
jse.libs.theme.modal.magnific = jse.libs.theme.modal.magnific || {};

/**
 * ## Honeygrid Modal Magnific (Library Extension)
 *
 * Library-function to open default modal layer. This function depends on jQuery & jQuery UI.
 *
 * @module Honeygrid/Libs/modal.ext-magnific
 * @exports jse.libs.modal.ext-magnific
 * @ignore
 */
(function (exports) {
    'use strict';

    var $document = $(document),
        $body = $('body');

    var _openLayer = function _openLayer(dataset, deferred, getFormData, originalOptions) {

        var $wrap = null,
            $bg = null,
            $buttons = null,
            $closeX = null,
            $forms = null,
            promise = deferred.promise(),
            instance = null,
            defaults = {
            preloader: false
        },
            options = $.extend({}, defaults, dataset),
            uid = parseInt(Math.random() * 100000);

        // ADD BUTTON INFORMATION
        $.each(options.buttons, function (i, v) {
            options.showButtons = true;
            v.index = i;
            v.uid = uid;
        });

        // GENERATE LAYER
        options.items.src = Mustache.render($('#magnific_wrapper').html(), options);

        $.magnificPopup.open(options);
        instance = $.magnificPopup.instance;

        /**
         * Overwriting the instance previous() and next() methods
         * to prevent the tween effect due to
         * interferences with the swiper module
         */
        instance.prev = function () {
            return instance.content.find('.swiper-button-prev:first').click();
        };
        instance.next = function () {
            return instance.content.find('.swiper-button-next:first').click();
        };

        // GET SELECTIONS
        $wrap = $(instance.wrap);
        $bg = $(instance.bgOverlay);
        $buttons = $wrap.find('.modal-footer button');
        $closeX = $wrap.find('button.mfp-close');

        // ########## EVENT HANDLER ##########

        // REMOVE MAGNIFIC EVENT HANDLER
        $wrap.off('click.mfp');
        $bg.off('click.mfp');
        $document.off('keyup.mfp');

        // BIND BUTTON HANDLER
        $buttons.each(function () {
            var $self = $(this),
                data = $self.data();

            if (typeof data.index === 'number') {
                $self.on('click', dataset.buttons[data.index].event);
            }
        });

        // BIND EVENT HANDLER FOR THE CLOSE BUTTON
        $closeX.off('click').on('click', function (e) {
            e.stopPropagation();
            _rejectHandler($wrap, deferred, getFormData);
        });

        // BIND EVENT HANDLER FOR BACKGROUND LAYER
        if (dataset.closeOnBgClick) {

            $wrap.off('click').on('click', function (e) {
                if (!$(e.target).closest('.modal-dialog').length) {
                    _rejectHandler($wrap, deferred, getFormData);
                }
            });
        }

        // BIND CLOSE HANDLER FOR ESC-KEY
        if (dataset.enableEscapeKey) {

            $document.on('keyup.magnific', function (e) {
                if (e.keyCode === 27) {
                    _rejectHandler($wrap, deferred, getFormData);
                }
            });
        }

        // ADD A CLOSE LAYER METHOD TO THE PROMISE
        // TODO: TESTING
        deferred.close = function (success) {
            if (success) {
                _resolveHandler($wrap, deferred, getFormData);
            } else {
                _rejectHandler($wrap, deferred, getFormData);
            }
        };

        // EXECUTE ADDITIONAL FUNCTION CODE ON LAYER OPEN
        if (options.executeCode && typeof options.executeCode === 'function') {
            options.executeCode.call($wrap);
        }

        if (originalOptions.bootstrapClass !== undefined) {
            $wrap.find('.modal-dialog').addClass(originalOptions.bootstrapClass);
        }

        if (originalOptions.zIndex !== undefined) {
            $wrap.css('z-index', originalOptions.zIndex);
        }

        jse.libs.theme.modal.finalizeLayer($wrap, originalOptions);

        return promise;
    };

    var _convertTemplate = function _convertTemplate(key, value) {
        var newValue = {
            src: value,
            type: 'inline'
        };

        return ['items', newValue];
    };

    var _getMapper = function _getMapper() {
        return {
            dialogClass: 'mainClass',
            modal: false,
            closeOnEscape: 'enableEscapeKey',
            closeOnOuter: 'closeOnBgClick',
            closeX: 'showCloseBtn',
            storeTemplate: false,
            template: _convertTemplate
        };
    };

    var _rejectHandler = function _rejectHandler($element, deferred, getFormData) {
        $element = $element.closest('.mfp-wrap');
        getFormData($element).always(function (result) {
            $document.off('keyup.magnific');
            deferred.reject(result);
            $.magnificPopup.close();
        });
    };

    var _resolveHandler = function _resolveHandler($element, deferred, getFormData) {
        $element = $element.closest('.mfp-wrap');
        getFormData($element, true).done(function (result) {
            $document.off('keyup.magnific');
            deferred.resolve(result);
            $.magnificPopup.close();
        });
    };

    // ########## VARIABLE EXPORT ##########

    exports.openLayer = _openLayer;
    exports.getMapper = _getMapper;
    exports.getResolveHandler = _resolveHandler;
    exports.getRejectHandler = _rejectHandler;
})(jse.libs.theme.modal.magnific);

jse.libs.template.modal = jse.libs.template.modal || {};
jse.libs.template.modal.magnific = jse.libs.theme.modal.magnific;
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
